/*
  Modify from Liquid Crystal example
  For Mini Mic Module
  Using BBFuino from Cytron Technologies with 8x2 character LCD
 
  The circuit:
 * 8x2 character LCD to BBFuino
 * LCD RS pin to digital pin 8
 * LCD Enable pin to digital pin 9
 * LCD D4 pin to digital pin 4
 * LCD D5 pin to digital pin 5
 * LCD D6 pin to digital pin 6
 * LCD D7 pin to digital pin 7
 * LCD R/W pin to ground
 * 10K resistor:
 * ends to +5V and ground
 * wiper to LCD VO pin (pin 3)
 
 Mini Mic module to BBFuino
 *VCC to 5V 
 *GND to GND
 *DO to D2
 */
 
// include the library code:
#include <LiquidCrystal.h>

#define Mic     2   //Digital output from Mini Mic module is connected to D2
#define LED     13  //LED at D13 pin

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);

void setup() {
  //setup the input or output pin
  pinMode(LED, OUTPUT);
  pinMode(Mic, INPUT);
  digitalWrite(LED, LOW);  //off LED  
  // set up the LCD's number of columns and rows: 
  lcd.begin(8, 2);
  // Print a message to the LCD.
  lcd.print("Micropho!");
  delay(1000);  //delay for 1 second  
}

void loop() 
{  
 if(digitalRead(Mic) == 0) // When the Mini Mic Module's DO is low, means sound detected.
  {   
    digitalWrite(LED,HIGH);
    lcd.setCursor(0, 0);  //move LCD cursor    
    lcd.print("SOUND!! ");  //Display message
    delay(400);
  }
  else 
  {    
    digitalWrite(LED,LOW);
    lcd.setCursor(0, 0);  //move LCD cursor
    //lcd.print(TempValue);
    lcd.print("NO SOUND");  //Display message   
  }
  
}

